// By EVOLVED
// www.evolved-software.com

#include "Settings.fx"

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 ViewProj:ViewProjection; 
   float4x4 ViewInv:ViewInverse;

//--------------
// tweaks
//--------------
   float4 CameraPosition;
   float4 FogColor;
   float3 FogDensity;
   float4 FogHeight;
   float4 FogHeightColor;
   float3 AmbientSky;
   float3 AmbientGround;
   float3 LightingRange;
   float3 LightingTexture;
   float3 ReflectionColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float4 ShadowNoise;
   float4 ShadowBlur;
   float3 ShadowBlurSplit;
   float4x4 ShadowProj;
   float3 ShadowDirection;
   float4 ShadowPosition;
   float4 ShadowRanges;
   float4x4 ShadowProjection;
   float3 ShadowProjPos1;
   float3 ShadowProjPos2;
   float3 ShadowProjPos3;
   float3 ShadowPositionX;
   float3 ShadowPositionY;
   float3 ShadowPositionZ;
   float4x4 VarianceShadowProjection;
   float3 VarianceShadowPosition;
   float4 VariancePosition;
   float Normalz;
   float4 TerrainSize;
   float4 TerrainTileSize;
   float TerrainHeight;
   float4 TreeWindTimer;
   float4 TreeWindSize={1000,2000,400,5};
   float3 TreeWindPower={32.0,16.0,4.0};

//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;	
   sampler BaseSampler=sampler_state 
      {
         Texture=<BaseTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
      };
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	 Texture=<NormalMapTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
      };
   texture TerrainTexture <string Name = "";>;	
   sampler TerrainSampler=sampler_state 
      {
         Texture=<TerrainTexture>;
         MipFilter=None;
         MinFilter=None;
         MagFilter=None;
	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture LightTexture <string Name="";>;
   sampler LightSampler=sampler_state
      {
	 Texture=<LightTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      };
   texture LightDataTexture <string Name = "";>;
   sampler LightDataSampler=sampler_state
      {
 	 Texture=<LightDataTexture>;
  	 MagFilter=None;
	 MinFilter=None;
	 MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow1Texture <string Name = "";>;
   sampler Shadow1Sampler=sampler_state
      {
 	 Texture=<Shadow1Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         AddressU=Border;
         AddressV=Border;
         AddressW=Border;
         BorderColor=16646655;
      };
   texture Shadow2Texture <string Name = "";>;
   sampler Shadow2Sampler=sampler_state
      {
 	 Texture=<Shadow2Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow3Texture <string Name = "";>;
   sampler Shadow3Sampler=sampler_state
      {
 	 Texture=<Shadow3Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };

//--------------
// Functions
//--------------
   #include "Tile Count.fx"
   #include "Tile Array.fx"
   #include "Diffuse Light.fx"
   #include "Spot Light.fx"
   #if Specularity == 1
    #include "Specular Light.fx"
   #endif
   #include "Vertex Fog.fx"
   #include "Vertex Ambient.fx"
   #include "Vertex Lighting.fx"
   #include "Reflections.fx"
   #if TerrainShadows == 1
    #include "Variance Shadow Mapping.fx"
   #endif

//--------------
// structs 
//--------------
   struct Input
      {
         float4 Pos:POSITION;
         float3 Normal:NORMAL;
         float2 Tex0:TEXCOORD0;
         float2 Tex1:TEXCOORD1;
         float2 Tex2:TEXCOORD2;
         float3 Color:COLOR0;
      };
   struct Out_Lighting
      {
         float4 Pos:POSITION;
         float3 Tex:TEXCOORD0;
         float4 TBNRow1:TEXCOORD1;
         float4 TBNRow2:TEXCOORD2;
         float4 TBNRow3:TEXCOORD3;
         float4 ViewVec:TEXCOORD4;
         float4 WorldPos:TEXCOORD5;
         float3 Lighting:TEXCOORD6;
         float4 Directional:TEXCOORD7;
         float4 Ambient:COLOR0;
         float4 Reflect:COLOR1;
      };
   struct Out_Depth
      {
         float4 Pos:POSITION; 
         float2 Tex:TEXCOORD0; 
         float3 Depth:TEXCOORD1;
      };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN) 
      {
         Out_Lighting OUT;
         float Scale=1.0;
         float4 Limits=float4(0.0,-1.0,0.0,1.0);
         float3 WorldPos=0.0, CenterPos=0.0;
         if(IN.Tex1.y>0.0) {
          float Index=floor(IN.Tex1.y);
          float4 Batch=float4(Index,floor(Index/252.0),0.0,0.0);
          Batch.xy=float2(Batch.x-(Batch.y*252.0),Batch.y+128.0)/256.0;
          float4 WMat1=tex2Dlod(LightDataSampler,Batch);
          float4 WMat2=tex2Dlod(LightDataSampler,Batch+float4(0.00390625,0.0,0.0,0.0));
          float4 WMat3=tex2Dlod(LightDataSampler,Batch+float4(0.0078125,0.0,0.0,0.0));
          float3x3 WorldMat={WMat1.xyz,WMat2.xyz,WMat3.xyz};
          WorldPos=mul(IN.Pos,WorldMat).xyz+float3(WMat1.w,WMat2.w,WMat3.w)+CameraPosition;
          CenterPos=mul(float3(IN.Tex2.x,0.0,IN.Tex2.y),WorldMat).xyz+float3(WMat1.w,WMat2.w,WMat3.w)+CameraPosition;
          Limits=float4(World[3].x*(IN.Tex1.x/1000.0),World[3].y,floor(World[3].z),frac(World[3].z));
          Scale=1.0-pow(saturate(length(CameraPosition-CenterPos)/Limits.x),2.5);
          WorldPos.y -=WMat2.w+CameraPosition.y, CenterPos.y -=WMat2.w+CameraPosition.y;
         }
         else {
          WorldPos=mul(IN.Pos,World);
          WorldPos.y -=World[3].y;
          CenterPos=mul(float3(IN.Tex2.x,0.0,IN.Tex2.y),World);
         }
         float4 NewUv=float4((CenterPos.xz/TerrainTileSize.xy)+TerrainTileSize.zw,0,0);
         NewUv=NewUv.xyxy+float4(0.0,0.0,1.0/TerrainSize.x,1.0/TerrainSize.y)-0.5/TerrainSize.x;
         float4x4 Terrain=float4x4(tex2Dlod(TerrainSampler,NewUv.xyww),tex2Dlod(TerrainSampler,NewUv.zyww),tex2Dlod(TerrainSampler,NewUv.xwww),tex2Dlod(TerrainSampler,NewUv.zwww));
         Terrain[0].x=abs(floor(Terrain[0].x)-Limits.y), Terrain[1].x=abs(floor(Terrain[1].x)-Limits.y), Terrain[2].x=abs(floor(Terrain[2].x)-Limits.y), Terrain[3].x=abs(floor(Terrain[3].x)-Limits.y);
         float2 BlendFrac=frac(TerrainSize.x*NewUv);
         Terrain[0]=lerp(lerp(Terrain[0],Terrain[2],BlendFrac.y),lerp(Terrain[1],Terrain[3],BlendFrac.y),BlendFrac.x);
         float3 TerrainNormals=normalize(float3(Terrain[0].y,0.75,Terrain[0].z));
         WorldPos=((WorldPos-CenterPos)*saturate(Scale))+CenterPos;
         WorldPos.y +=Terrain[0].w*TerrainHeight;
         if(Limits.y>-1 && floor(Terrain[0].x+0.5)!=0) WorldPos=float3(0.0,-99999999.0,0.0);
         if(1.0-TerrainNormals.y<Limits.z*0.01 || 1.0-TerrainNormals.y>Limits.w) WorldPos=float3(0.0,-99999999.0,0.0);
         OUT.Pos=mul(float4(WorldPos,1),ViewProj);
         OUT.Tex.xy=IN.Tex0;
         OUT.TBNRow1.xyz=0.0;
         OUT.TBNRow2.xyz=0.0;
         OUT.TBNRow3.xyz=TerrainNormals;
         OUT.ViewVec.xyz=ViewInv[3].xyz-WorldPos;
         OUT.WorldPos=float4(WorldPos,0); 
         float3 ViewVec=normalize(OUT.ViewVec.xyz);
         float ViewDepth=length(OUT.ViewVec.xyz);
         OUT.Tex.z=1.0;
         #if Shadows == 1
          #if TerrainShadows == 1
           float2 ShadowProj=float2(0.75,0.5)+mul(float4(WorldPos,1.0),VarianceShadowProjection)*float2(0.25,-0.5);
           float Depth=dot(WorldPos-VarianceShadowPosition,ShadowDirection)/ShadowRanges.w;
           float Edge=saturate(VariancePosition.w-length(WorldPos-VariancePosition.xyz));
           OUT.Tex.z=lerp(1.0,VarianceShadowMapping(ShadowProj,saturate(Depth)),Edge);
          #endif
         #endif
         float4 Project=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z,OUT.Pos.w);
         Project.xy /=Project.w;
         float4 WorldCamPos=OUT.WorldPos-CameraPosition;
         OUT.Lighting=0.0;
         float Index=floor(Project.x*16.0)+floor(Project.y*8.0)*16.0;
         int2 Tiles=TileCount(Project*float2(0.0625,0.03125),ViewDepth/LightingRange.x);
         for(int i=0; i<Tiles.x; i++ ) {
          float TileArray=TileArray(i+128.0,Index,Tiles.y);
          OUT.Lighting +=VertexLighting(TileArray,WorldCamPos,TerrainNormals);
         }
         OUT.Directional.xyz=DiffuseLight(LightDirection,TerrainNormals,LightDirectionColor);
         OUT.Directional.w=max(dot(normalize(LightDirection+ViewVec),TerrainNormals),0.0);
	 float3 AmbientDir=normalize(float3(-LightDirection.x,1.0,-LightDirection.z));
         OUT.Ambient.xyz=lerp(AmbientGround,AmbientSky,0.5+dot(TerrainNormals,AmbientDir)*0.5);
         float LightSegment=clamp(floor((ViewDepth/LightingRange.z)*16.0),0.0,15.0)*0.00390625;
         int LightCount=tex2Dlod(LightDataSampler,float4(0.12890625,LightSegment,0.0,0.0));
         float4 AmbientLighting=0.0;
         for (int l=0; l < LightCount; l++) {
          AmbientLighting=max(VertexAmbient((34.0+l)*0.00390625,LightSegment,WorldCamPos),AmbientLighting);
         }
         OUT.Ambient.xyz=lerp(OUT.Ambient.xyz,AmbientLighting.xyz,AmbientLighting.w);
         OUT.Ambient.w=frac(IN.Tex1.x);
         OUT.Reflect.xyz=lerp(ReflectionColor,1.0,AmbientLighting.w);
         OUT.Reflect.w=max((0.5+dot(-LightDirection,TerrainNormals)*0.5)*dot(normalize(-LightDirection+ViewVec),ViewVec),0.0);
         float4 Fog=VertexFog(ViewDepth,WorldPos,ViewVec,LightDirection,LightDirectionColor,FogColor,FogDensity,FogHeightColor,FogHeight);
         OUT.TBNRow1.w=Fog.x, OUT.TBNRow2.w=Fog.y, OUT.TBNRow3.w=Fog.z, OUT.ViewVec.w=Fog.w;
         return OUT;
      }
   Out_Depth VS_DepthMapDir(Input IN)
      {
         Out_Depth OUT;
         float Scale=1.0;
         float4 Limits=float4(0.0,-1.0,0.0,1.0);
         float3 WorldPos=0.0, CenterPos=0.0;
         if(IN.Tex1.y>0.0) {
          float Index=floor(IN.Tex1.y);
          float4 Batch=float4(Index,floor(Index/252.0),0.0,0.0);
          Batch.xy=float2(Batch.x-(Batch.y*252.0),Batch.y+128.0)/256.0;
          float4 WMat1=tex2Dlod(LightDataSampler,Batch);
          float4 WMat2=tex2Dlod(LightDataSampler,Batch+float4(0.00390625,0.0,0.0,0.0));
          float4 WMat3=tex2Dlod(LightDataSampler,Batch+float4(0.0078125,0.0,0.0,0.0));
          float3x3 WorldMat={WMat1.xyz,WMat2.xyz,WMat3.xyz};
          WorldPos=mul(IN.Pos,WorldMat).xyz+float3(WMat1.w,WMat2.w,WMat3.w)+CameraPosition;
          CenterPos=mul(float3(IN.Tex2.x,0.0,IN.Tex2.y),WorldMat).xyz+float3(WMat1.w,WMat2.w,WMat3.w)+CameraPosition;
          Limits=float4(World[3].x*(IN.Tex1.x/1000.0),World[3].y,floor(World[3].z),frac(World[3].z));
          Scale=1.0-pow(saturate(length(CameraPosition-CenterPos)/Limits.x),2.5);
          WorldPos.y -=WMat2.w+CameraPosition.y, CenterPos.y -=WMat2.w+CameraPosition.y;
         }
         else {
          WorldPos=mul(IN.Pos,World);
          WorldPos.y -=World[3].y;
          CenterPos=mul(float3(IN.Tex2.x,0.0,IN.Tex2.y),World);
         }
         float4 NewUv=float4((CenterPos.xz/TerrainTileSize.xy)+TerrainTileSize.zw,0,0);
         NewUv=NewUv.xyxy+float4(0.0,0.0,1.0/TerrainSize.x,1.0/TerrainSize.y)-0.5/TerrainSize.x;
         float4x4 Terrain=float4x4(tex2Dlod(TerrainSampler,NewUv.xyww),tex2Dlod(TerrainSampler,NewUv.zyww),tex2Dlod(TerrainSampler,NewUv.xwww),tex2Dlod(TerrainSampler,NewUv.zwww));
         Terrain[0].x=abs(floor(Terrain[0].x)-Limits.y), Terrain[1].x=abs(floor(Terrain[1].x)-Limits.y), Terrain[2].x=abs(floor(Terrain[2].x)-Limits.y), Terrain[3].x=abs(floor(Terrain[3].x)-Limits.y);
         float2 BlendFrac=frac(TerrainSize.x*NewUv);
         Terrain[0]=lerp(lerp(Terrain[0],Terrain[2],BlendFrac.y),lerp(Terrain[1],Terrain[3],BlendFrac.y),BlendFrac.x);
         float3 TerrainNormals=normalize(float3(Terrain[0].y,0.75,Terrain[0].z));
         WorldPos=((WorldPos-CenterPos)*saturate(Scale))+CenterPos;
         WorldPos.y +=Terrain[0].w*TerrainHeight;
         if(Limits.y>-1 && floor(Terrain[0].x+0.5)!=0) WorldPos=float3(0.0,-99999999.0,0.0);
         if(1.0-TerrainNormals.y<Limits.z*0.01 || 1.0-TerrainNormals.y>Limits.w) WorldPos=float3(0.0,-99999999.0,0.0);
         OUT.Pos=mul(float4(WorldPos,1.0),ShadowProj);
         OUT.Tex=IN.Tex0;
         OUT.Depth=WorldPos-ShadowPosition.xyz;
         return OUT;
      }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting(Out_Lighting IN)  : COLOR
      {
         float ViewDepth=length(IN.ViewVec.xyz);
         float3 ViewVec=normalize(IN.ViewVec.xyz);
         float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);
         float4 NormalMap=tex2D(NormalMapSampler,IN.Tex.xy);
         float ViewNormal=max(dot(ViewVec,IN.TBNRow3.xyz),0.0);
         float3 Specular=0.04+0.96*pow(1.0-NormalMap.z,2.2)*pow(1.0-ViewNormal,5.0);
         float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2.0);
         float3 ReflectionVec=reflect(-ViewVec,IN.TBNRow3.xyz);
         float3 LightSpecular=IN.Reflect.xyz*Reflections(ReflectionVec,NormalMap.z,LightingTexture.z);
         float3 Lighting=IN.Directional.xyz;
         #if Shadows == 1
          float3 ShadowProjPos[3]={IN.WorldPos.xyz-ShadowProjPos1,IN.WorldPos.xyz-ShadowProjPos2,IN.WorldPos.xyz-ShadowProjPos3};
          float2 Split=float2(length(ShadowProjPos[0].xyz),length(ShadowProjPos[1].xyz))/ShadowRanges.xy*4.0;
          Split=saturate(floor(Split));
          Split.x +=Split.y;
	  float Depth=dot(IN.WorldPos.xyz-float3(ShadowPositionX[Split.x],ShadowPositionY[Split.x],ShadowPositionZ[Split.x]),ShadowDirection)/ShadowRanges[Split.x];
	  float2 ShadowProj=0.5+mul(float4(ShadowProjPos[Split.x],1.0),ShadowProjection/ShadowRanges[Split.x]*2.0)*float2(0.5,-0.5);
          float Shadow=step(saturate(Depth),tex2Dlod(Shadow1Sampler,ShadowProj.xyyy)[Split.x])*IN.Tex.z;
          Lighting *=Shadow;
          IN.Reflect.w *=Shadow;
         #endif
         #if Specularity == 1
          float HalfVec=IN.Directional.w*(Distribution-1.0)+1.0001;
          LightSpecular +=(Distribution/(3.141592*HalfVec.x*HalfVec.x))*Lighting;
         #endif
         Lighting +=IN.Lighting+IN.Ambient.xyz;
         Lighting *=(1.0-Specular)*pow(Diffuse.xyz,2.2);
         Lighting +=LightSpecular*Specular;
	 Lighting +=Diffuse.xyz*IN.Reflect.w*NormalMap.x*LightDirectionColor;
         return float4(lerp(Lighting*IN.Ambient.w,float3(IN.TBNRow1.w,IN.TBNRow2.w,IN.TBNRow3.w),IN.ViewVec.w),ceil(Diffuse.w-0.25)*ViewDepth*0.5);
      }
   float4 PS_DepthMapDir(Out_Depth IN) : COLOR
      {
         return float4(0.004+(dot(IN.Depth,ShadowDirection)/ShadowPosition.w).xxx,tex2D(BaseSampler,IN.Tex).w);
      }

//--------------
// techniques   
//--------------
   technique Lighting
      {
         pass p1
      {      
         vertexShader = compile vs_3_0 VS_Lighting();
         pixelShader  = compile ps_3_0 PS_Lighting();
         AlphaBlendEnable=false;
         AlphaRef=0;
      }
      }
   technique DepthMap1
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
         AlphaBlendEnable=false;
         AlphaRef=64;
         ColorWriteEnable=1;
      }
      }
   technique DepthMap2
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
         AlphaBlendEnable=false;
         AlphaRef=64;
         ColorWriteEnable=2;
      }
      }
   technique DepthMap3
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
         AlphaBlendEnable=false;
         AlphaRef=64;
         ColorWriteEnable=4;
      }
      }

